<?php
/*
Plugin Name: DTS Blog Module Pro
Plugin URI: https://divithemestore.com/divi-shop/dts-blog-module-pro/
Description: A Brand new Divi Custom Modules for Divi Theme
Author: Divi Theme Store
Author URI: https://divithemestore.com/
Version: 2.1.5
License: GNU General Public License v2.0 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Text Domain:  dcm
 */
 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

//require_once( dirname(__FILE__) . '/inc/dts-blog-module-pro-license.php' );
if ( !class_exists( 'DTSBlogModulePro_License_Plugin' ) ) {
    require_once( plugin_dir_path( __FILE__ ) . 'dts-blog-module-pro-license.php' );
	/**
	 * @param string $file             Must be __FILE__ from the root plugin file, or theme functions file.
	 * @param string $software_title   Must be exactly the same as the Software Title in the product.
	 * @param string $software_version This product's current software version.
	 * @param string $plugin_or_theme  'plugin' or 'theme'
	 * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
	 *
	 * @return \AM_License_Submenu|null
	 */
     DTSBlogModulePro_License_Plugin::instance( __FILE__, 'DTS Blog Module Pro', '2.1.5', 'plugin', 'https://divithemestore.com/' );
}
add_action( 'init', 'dcm_load_textdomain' );

if (!function_exists ('dcm_load_textdomain')):
  function dcm_load_textdomain() {
    load_plugin_textdomain( 'dcm', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
  }
endif;

  add_action('plugins_loaded', 'dcm_blog_module_init');

  function dcm_blog_module_init() {
  	add_action('et_builder_ready', 'dcm_blog_module');
  	add_action( 'wp_enqueue_scripts', 'enqueue_custom_blog_module_scripts', 9999 );
  }
  //LOAD CUSTOM MODULE CLASS FILE
  function dcm_blog_module() {
    if ( !class_exists( 'ET_Builder_Module' ) ):
      return;
      else:
          include(DCM__PLUGIN_DIR .  '/class/DTSBlogModulePro.class.php' );
      endif;
  }
  //END CLASSES AND PLUGIN OPTIONS PAGE
// DIVI THEME STORE LOAD CLASSES AND PLUGIN OPTIONS PAGE
define( 'DCM__PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
include (DCM__PLUGIN_DIR . 'dcm-page.php');
require_once( DCM__PLUGIN_DIR . 'class/dcm-pop-posts.class.php' );
require_once( DCM__PLUGIN_DIR . 'class/dcm-latest-posts.class.php' );
require_once( DCM__PLUGIN_DIR . 'class/dcm-custom-about.class.php' );
require( DCM__PLUGIN_DIR . 'inc/customizer/customizer-control.php' );
//include(DCM__PLUGIN_DIR .  'templates/taxonomy-project_category.php');

require (DCM__PLUGIN_DIR . '/inc/customizer/astra-customizer.class.php');
new Astra_Customizer();
//LOAD TEMPLATES
add_filter('template_include', 'DCM_set_template');
function DCM_set_template( $template ){
    global $post; 
    if ($post->post_type == 'post' ):
    if(is_home() || is_archive() || is_category() || is_author() || is_tag() || is_search() && 'index.php' != $template ):
        $template = DCM__PLUGIN_DIR . '/templates/index.php';
    endif;
endif;
    return $template;
}
//END TEMPLATE

//STYLES
if (!function_exists('enqueue_custom_blog_module_scripts')):
  function enqueue_custom_blog_module_scripts() {
      wp_enqueue_style( 'dts-blog-css', plugin_dir_url( __FILE__ ) . 'assets/css/custom_blog_style.css' );
      wp_add_inline_style( 'dts-blog-css', astra_customizer_css() );
  }
endif;

add_image_size( 'medium_crop', 350, 210, true );

if ( ! function_exists( "enqueue_dcm_font_awesome" ) ):
    add_action( 'wp_enqueue_scripts', 'enqueue_dcm_font_awesome' );
    function enqueue_dcm_font_awesome() {
        wp_enqueue_style( 'font-awesome', '//maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css' );
    }
endif;
// END STYLES
