<?php

/**
 * Created by PhpStorm.
 * User: Fred
 * Date: 16/08/2016
 * Time: 00:49
 */
class DCM_Pop_Posts extends WP_Widget{


	function __construct() {
		$params = array(
			'description' => 'Display Popular Posts',
			'name'        => 'Divichild Popular Posts'
		);
		parent::__construct( 'DCM_Pop_Posts', '', $params );

	}

	public function form( $instance ) {
		extract( $instance );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ) ?>">Title:</label>
			<input
				type="text"
				class="widefat"
				id="<?php echo $this->get_field_id( 'title' ) ?>"
				name="<?php echo $this->get_field_name( 'title' ) ?>"
				value="<?php if ( isset( $title ) ) {
					echo esc_attr( $title );
				} ?>"
			/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'numberOfPosts' ) ?>">Number of Posts:</label>
			<input
				type="text"
				class="widefat"
				id="<?php echo $this->get_field_id( 'numberOfPosts' ) ?>"
				name="<?php echo $this->get_field_name( 'numberOfPosts' ) ?>"
				value="<?php if ( isset( $numberOfPosts ) ) {
					echo esc_attr( $numberOfPosts );
				} ?>"
			/>
		</p>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'popcateg' ) ?>">Category:</label>
			<input
				type="text"
				class="widefat"
				id="<?php echo $this->get_field_id( 'popcateg' ) ?>"
				name="<?php echo $this->get_field_name( 'popcateg' ) ?>"
				value="<?php if ( isset( $popcateg ) ) {
					echo esc_attr( $popcateg );
				} ?>"
			/>
		<?php
	}


	public function widget( $args, $instance ) {
		extract( $args );
		extract( $instance );
		if ( ! isset( $title ) ) {
			$title = '';
		}
		if ( ! isset( $numberOfPosts ) ) {
			$numberOfPosts = 5;
		}
		if ( ! isset( $popcateg ) ) {
			$popcateg = '';
		}
		?>
		<?php echo $before_widget; ?>
		<?php
		if ( ! empty( $title ) ) {
			echo $before_title . $title . $after_title;
		}
		?>
		<div class="side-list">
			<ul>
				<?php
				$wpbp = new WP_Query( array( 'post_type'      => 'post',
				                             'paged'          => 1,
				                             'posts_per_page' => $numberOfPosts,
				                             'orderby'        => 'comment_count',
				                             'category_name'  => $popcateg
				) );
				$temp_out = "";
				if ( $wpbp->have_posts() ) : while ( $wpbp->have_posts() ) : $wpbp->the_post();
					?>
					<article id="post-<?php the_ID(); ?>" <?php post_class( 'et_pb_post_custom astra_wid_article' ); ?>>
						<div class="header_post">
						<?php
						$thumb = '';

						$width = (int) apply_filters( 'et_pb_index_blog_image_width', 350 );

						$height = (int) apply_filters( 'et_pb_index_blog_image_height', 210 );
						$classtext = 'et_pb_post_main_image';
						$titletext = get_the_title();
						$thumbnail = get_thumbnail( $width, $height, $classtext, $titletext, $titletext, false, 'Blogimage' );
						$thumb = $thumbnail["thumb"];

						et_divi_post_format_content();

						if ( ! in_array( $post_format, array( 'link', 'audio', 'quote' ) ) ) {
							if ( 'video' === $post_format && false !== ( $first_video = et_get_first_video() ) ) :
								printf(
									'<div class="et_main_video_container">
									%1$s
								</div>',
									$first_video
								);
							elseif ( ! in_array( $post_format, array( 'gallery' ) ) && 'on' === et_get_option( 'divi_thumbnails_index', 'on' ) && '' !== $thumb ) : ?>
								<a href="<?php the_permalink(); ?>">
									<?php print_thumbnail( $thumb, $thumbnail["use_timthumb"], $titletext, $width, $height ); ?>
								</a>
								<?php
							elseif ( 'gallery' === $post_format ) :
								et_pb_gallery_images();
							endif;
						} ?>

						<?php if ( ! in_array( $post_format, array( 'link', 'audio', 'quote' ) ) ) : ?>
						<?php if ( ! in_array( $post_format, array( 'link', 'audio' ) ) ) : ?>
				</div>
				<div class="post_content">
				<h2 class="entry-title wid_astra"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
				<?php echo esc_attr( get_option('some_other_option') ); ?>
				<?php endif; ?>

				<?php endif; ?>
				</div>
				<div class="blog-p-meta">
						<span class="blog-author"> <i class="fa fa-pencil"></i><?php _e('','DIVI_TEXT_DOMAIN'); ?><?php the_author_posts_link(); ?></span>
						<span class="blog-comments"> <i class="fa fa-comment"></i><?php comments_number(  ); ?></span>
				</div>

				</article> <!-- .et_pb_post -->
					<?php
				endwhile; endif;
				wp_reset_query();
				?>
			</ul>
		</div>
		<?php echo $after_widget; ?><!-- Disclaimer -->
		<?php
	}
}
add_action( 'widgets_init', 'register_divichild_PopularPosts' );
function register_divichild_PopularPosts() {
	register_widget( 'DCM_Pop_Posts' );

}
