<?php

	class DiviBars_Controller {
		
		protected static $_show_errors = FALSE;
		
		private static $helper = NULL;
		private static $isMobileDevice = NULL;
		
		public function __construct() {
			
		}
		
		public static function showDiviBars( $params ) {
			
			// Settings
			self::$helper = new DiviBars_Helper;
			
			$function_exception = 'showDiviBars';
			
			try {
				
				print '<div id="sidebar-divibar">';
				
				
				/* Add Settings */
				print '<script type="text/javascript">var divibars_settings = {';
				
				$divibars_settings = get_option( 'dib_settings' );
				
				if ( isset( $divibars_settings['dib_custom_elems'] ) ) {
					
					print '\'dib_custom_elems\': \'' . $divibars_settings['dib_custom_elems'] . '\',';
				}
				
				print '};</script>';
				
				/* Search Divi divibar in current post */
				global $post;
				$post_content = $post->post_content;
				$matches = array();
				$pattern = '/id="(.*?divibars_[0-9]+)"/';
				preg_match_all($pattern, $post_content, $matches);
				
				$divibars_divibar_ = $matches[1];
				
				$matches = array();
				$pattern = '/id="(.*?divibars_unique_id_[0-9]+)"/';
				preg_match_all($pattern, $post_content, $matches);
				
				$divibars_divibar_unique_id_ = $matches[1];
				
				$matches = array();
				$pattern = '/class="(.*?divibar\-[0-9]+)"/';
				preg_match_all($pattern, $post_content, $matches);
				
				$divibars_class_divibar = $matches[1];
				
				$divibars_in_post = $divibars_divibar_ + $divibars_divibar_unique_id_ + $divibars_class_divibar;
				
				$divibars_in_post = array_filter( array_map( 'DiviBars_Helper::prepareBars', $divibars_in_post ) );
				
				if ( is_array( $divibars_in_post ) && count( $divibars_in_post ) > 0 ) {
					
					$divibars_in_post = array_flip( $divibars_in_post );
					
				}
				
				
				/* Search Divi divibar in active menus */
				$theme_locations = get_nav_menu_locations();
				
				$divibars_in_menus = array();
				
				if ( is_array( $theme_locations ) && count( $theme_locations ) > 0 ) {
					
					$divibars_in_menus = array();
					
					foreach( $theme_locations as $theme_location => $theme_location_value ) {
						
						$menu = get_term( $theme_locations[$theme_location], 'nav_menu' );
						
						// menu exists?
						if( !is_wp_error($menu) ) {
							
							$menu_items = wp_get_nav_menu_items($menu->term_id);
							
							foreach ( (array) $menu_items as $key => $menu_item ) {
								
								$url = $menu_item->url;
								
								if ( $url ) {
									
									$extract_id = self::$helper->prepareBars( $url );
									
									if ( $extract_id ) {
										
										$divibars_in_menus[ $extract_id ] = 1;
									}
								}
								
								/* Search Divi divibar in menu classes */
								if ( count( $menu_item->classes ) > 0 && $menu_item->classes[0] != '' ) {
									
									foreach ( $menu_item->classes as $key => $class ) {
										
										if ( $class != '' ) {
											
											$extract_id = self::$helper->prepareBars( $class );
											
											if ( $extract_id ) {
											
												$divibars_in_menus[ $extract_id ] = 1;
											}
										}
									}
								}
							}
						}
						else {
							
							
						}
					}
				}
				
				$divibars_in_menus = array_filter( $divibars_in_menus );
				
				
				/* Search CSS Triggers in all Divi divibars */
				global $wp_query;
				
				$args = array(
					'meta_key'   => 'dib_css_selector',
					'meta_value' => '',
					'meta_compare' => '!=',
					'post_type' => 'divi_bars',
					'cache_results'  => false
				);
				$query = new WP_Query( $args );
				
				$posts = $query->get_posts();
				
				$divibars_with_css_trigger = array();
				
				if ( isset( $posts[0] ) ) {
					
					print '<script type="text/javascript">var divibars_with_css_trigger = {';
					
					foreach( $posts as $dv_post ) {
						
						$display_in_current = false;
						
						$post_id = $dv_post->ID;
						
						$at_pages = get_post_meta( $post_id, 'css_selector_at_pages' );
						
						$display_in_posts = ( !isset( $at_pages[0] ) ) ? 'all' : $at_pages[0];
						
						if ( $display_in_posts == 'specific' ) {
							
							$in_posts = get_post_meta( $post_id, 'css_selector_at_pages_selected' );
							
							foreach( $in_posts[0] as $in_post => $the_id ) {
								
								if( $the_id == $post->ID ) {
									
									$display_in_current = true;
									
									break;
								}
							}
						}
						
						
						if ( $display_in_posts == 'all' || $display_in_current ) {
						
							$get_css_selector = get_post_meta( $post_id, 'dib_css_selector' );
							
							$css_selector = $get_css_selector[0];
							
							if ( $css_selector != '' ) {
								
								print '\'' . $post_id . '\': \'' . $css_selector . '\',';
								
								$divibars_with_css_trigger[ $post_id ] = $css_selector;
							}
						}
					}
					
					print '};</script>';
				}
				
				
				/* Search URL Triggers in all Divibars */
				$args = array(
					'meta_key'   => 'dib_enableurltrigger',
					'meta_value' => '1',
					'meta_compare' => '=',
					'post_type' => 'divi_bars',
					'cache_results'  => false
				);
				$query = new WP_Query( $args );
				
				$posts = $query->get_posts();
				
				$divibars_with_url_trigger = array();
				
				if ( isset( $posts[0] ) ) {
					
					$display_in_current = false;
					
					foreach( $posts as $dv_post ) {
						
						$post_id = $dv_post->ID;
						
						$enableurltrigger_pages = get_post_meta( $post_id, 'dib_enableurltrigger_pages' );
						
						$display_in_posts = $enableurltrigger_pages[0];
						
						if ( $display_in_posts == 'specific' ) {
							
							$in_posts = get_post_meta( $post_id, 'dib_enableurltrigger_selectedpages' );
							
							foreach( $in_posts[0] as $in_post => $the_id ) {
								
								if( $the_id == $post->ID ) {
									
									$display_in_current = true;
									
									break;
								}
							}
						}
						
						if ( $display_in_posts == 'all' || $display_in_current ) {
							
							$divibars_with_url_trigger[ $post_id ] = 1;
						}
					}
				}
				$divibars_with_url_trigger = array_filter( $divibars_with_url_trigger );
				
				
				/* Search Automatic Triggers in all Divi divibars */
				
				// Server-Side Device Detection with Browscap
				require_once( plugin_dir_path( __FILE__ ) . 'php-libraries/Browscap/Browscap.php' );
				$browscap = new Browscap( plugin_dir_path( __FILE__ ) . '/php-libraries/Browscap/Cache/' );
				$browscap->doAutoUpdate = false;
				$current_browser = $browscap->getBrowser();
				
				self::$isMobileDevice = $current_browser->isMobileDevice;
				
				$divibars_with_automatic_trigger = array();
				
				$args = array(
					'meta_key'   => 'divibars_automatictrigger',
					'meta_value' => '',
					'meta_compare' => '!=',
					'post_type' => 'divi_bars',
					'cache_results'  => false
				);
				$query = new WP_Query( $args );
				
				$posts = $query->get_posts();
				
				if ( isset( $posts[0] ) ) {
					
					print '<script type="text/javascript">var divibars_with_automatic_trigger = {';
					
					$display_in_current = null;
					
					foreach( $posts as $dv_post ) {
						
						$display_in_current = false;
						
						$post_id = $dv_post->ID;
						
						$at_pages = get_post_meta( $post_id, 'at_pages' );
						
						$display_in_posts = ( $at_pages[0] == NULL ) ? 'all' : $at_pages[0];
						
						if ( $display_in_posts == 'specific' ) {
							
							$in_posts = get_post_meta( $post_id, 'at_pages_selected' );
							
							foreach( $in_posts[0] as $in_post => $the_id ) {
								
								if( $the_id == $post->ID ) {
									
									$display_in_current = true;
									
									break;
								}
							}
						}
						
						if ( $display_in_posts == 'all' || $display_in_current ) {
							
							$at_disablemobile = get_post_meta( $post_id, 'divibars_automatictrigger_disablemobile' );
							$onceperload = get_post_meta( $post_id, 'divibars_automatictrigger_onceperload', true );
							
							if ( isset( $onceperload[0] ) ) {
								
								$onceperload = $onceperload[0];
								
							} else {
								
								$onceperload = 1;
							}
							
							if ( isset( $at_disablemobile[0] ) ) {
								
								$at_disablemobile = $at_disablemobile[0];
								
							} else {
								
								$at_disablemobile = 1;
							}
							
							$printSettings = 1;
							if ( $at_disablemobile && self::$isMobileDevice ) {
								
								$printSettings = 0;
							}
							
							if ( $printSettings ) {
								
								$at_type = get_post_meta( $post_id, 'divibars_automatictrigger', true );
								$at_timed = get_post_meta( $post_id, 'divibars_automatictrigger_timed_value', true );
								$at_scroll_from = get_post_meta( $post_id, 'divibars_automatictrigger_scroll_from_value', true );
								$at_scroll_to = get_post_meta( $post_id, 'divibars_automatictrigger_scroll_to_value', true );
								
								if ( $at_type != '' ) {
									
									switch ( $at_type ) {
										
										case 'divibar-timed':
											$at_value = $at_timed;
										break;
										
										case 'divibar-scroll':
											$at_value = $at_scroll_from . ':' . $at_scroll_to;
										break;
										
										default:
											$at_value = $at_type;
									}
									
									$at_settings = json_encode( array( 'at_type' => $at_type, 'at_value' => $at_value, 'at_onceperload' => $onceperload ) );
									
									print '\'' . $post_id . '\': \'' . $at_settings . '\',';
									
									$divibars_with_automatic_trigger[ $post_id ] = $at_type;
								}
							}
						}
					}
					
					print '};</script>';
				}
				$divibars_with_automatic_trigger = array_filter( $divibars_with_automatic_trigger );
				
				
				/* Search Divi divibars with Custom Close Buttons */
				$args = array(
					'meta_key'   => 'post_do_customizeclosebtn',
					'meta_value' => '',
					'meta_compare' => '!=',
					'post_type' => 'divi_bars',
					'cache_results'  => false
				);
				$query = new WP_Query( $args );
				
				$posts = $query->get_posts();
				
				if ( isset( $posts[0] ) ) {
					
					print '<style type="text/css">';
					
					foreach( $posts as $dv_post ) {
						
						$post_id = $dv_post->ID;
						
						$cbc_textcolor = get_post_meta( $post_id, 'post_closebtn_text_color', true );
						$cbc_bgcolor = get_post_meta( $post_id, 'post_closebtn_bg_color', true );
						$cbc_fontsize = get_post_meta( $post_id, 'post_closebtn_fontsize', true );
						$cbc_borderradius = get_post_meta( $post_id, 'post_closebtn_borderradius', true );
						$cbc_padding = get_post_meta( $post_id, 'post_closebtn_padding', true );
						
						$customizeclosebtn = get_post_meta( $post_id, 'post_do_customizeclosebtn' );
						if ( isset( $customizeclosebtn[0] ) ) {
							
							$customizeclosebtn = $customizeclosebtn[0];
							
						} else {
							
							continue;
						}
						
						if ( $customizeclosebtn ) {
							
							print '
							.divibar-customclose-btn-' . $post_id . ' {
								top:5px !important;
								color:' . $cbc_textcolor . ' !important;
								background-color:' . $cbc_bgcolor . ' !important;
								font-size:' . $cbc_fontsize . 'px !important;
								padding:' . $cbc_padding . 'px !important;
								-moz-border-radius:' . $cbc_borderradius . '% !important;
								-webkit-border-radius:' . $cbc_borderradius . '% !important;
								-khtml-border-radius:' . $cbc_borderradius . '% !important;
								border-radius:' . $cbc_borderradius . '% !important;
							}
							';
						}
					}
					
					print '</style>';
				}
				
				
				/* Ignore repeated ids and print divibars */
				$divibars = $divibars_in_post + $divibars_in_menus + $divibars_with_css_trigger + $divibars_with_url_trigger + $divibars_with_automatic_trigger;
				
				if ( is_array( $divibars ) && count( $divibars ) > 0 ) {
					
					foreach( $divibars as $divibar_id => $idx ) {
						
						print self::divibar_render( $divibar_id );
					}
				}
				
				print '</div>';
				
				?>
				<script type="text/javascript">
				var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
				var diviAjaxUrl = '<?php print plugins_url( 'ajax-handler-wp.php' , __FILE__ ); ?>';
				</script>
				<?php
			
			} catch (Exception $e) {
			
				self::log( $e );
			}
			
			
			wp_register_script('exit-intent', DIVI_BARS_PLUGIN_URL . 'assets/js/jquery.exitintent.min.js', array('jquery') );
			
			wp_enqueue_script('exit-intent');
		}
		
		
		public static function divibar_render( $divibar_id = NULL ) {
			
			if ( !is_numeric( $divibar_id ) ) {
				
				throw new InvalidArgumentException( 'divibar_render > $divibar_id is not numeric');
			}
			
			$divibar_id = (int) $divibar_id;
			
			$post_data = get_post( $divibar_id );
			
			
			/* Scheduling */
			$enable_scheduling = get_post_meta( $post_data->ID, 'divibars_enable_scheduling' );
			
			if( !isset( $enable_scheduling[0] ) ) {
				
				$enable_scheduling[0] = 0;
			}
			
			$enable_scheduling = (int) $enable_scheduling[0];
			
			if ( $enable_scheduling ) {
				
				$date_start = get_post_meta( $post_data->ID, 'divibars_date_start', true );
				$date_end = get_post_meta( $post_data->ID, 'divibars_date_end', true );
				
				$date_start = DiviBars::$helper->convertDateToUserTimezone( $date_start );
				
				$divibars_settings = get_option( 'dib_settings' );
				
				$timezone = DIVI_SERVER_TIMEZONE;
				
				if ( isset( $divibars_settings['dib_timezone'] ) ) {
					
					$timezone = $divibars_settings['dib_timezone'];
				}
				
				$timezone = new DateTimeZone( $timezone );
				
				$date_now = new DateTime( 'now', $timezone );
				$date_start = new DateTime( $date_start, $timezone );
				
				if ( $date_start >= $date_now ) {
					
					return;
				}
				
				if ( $date_end != '' ) {
				
					$date_end = DiviBars::$helper->convertDateToUserTimezone( $date_end );
					$date_end = new DateTime( $date_end, $timezone );
					
					if ( $date_end <= $date_now ) {
						
						return;
					}
				}
			}
			
			
			$divibar_effect = get_post_meta( $post_data->ID,'_et_pb_divibar_effect', true );
			
			if ( $divibar_effect == '' ) {
				
				$divibar_effect = 'divibar-hugeinc';
			}
			
			global $wp_embed;
			
			$wp_embed->post_ID = $post_data->ID;
			
			// [embed] shortcode
			$wp_embed->run_shortcode( $post_data->post_content );
			
			// plain links on their own line
			$wp_embed->autoembed( $post_data->post_content );
			
			// Enable shortcodes
			$output = do_shortcode( $post_data->post_content );
			
			$bgcolor = get_post_meta( $post_data->ID, 'post_divibars_bg_color', true );
			$fontcolor = get_post_meta( $post_data->ID, 'post_divibars_font_color', true );
			
			$hideclosebtn = get_post_meta( $post_data->ID, 'post_do_hideclosebtn' );
			if ( isset( $hideclosebtn[0] ) ) {
				
				$hideclosebtn = $hideclosebtn[0];
				
			} else {
				
				$hideclosebtn = 0;
			}
			
			$placement = get_post_meta( $post_data->ID, 'dib_post_placement', true );
			if( !isset( $placement ) ) {
				
				$placement = 'top';
			}
			
			$pushpage = get_post_meta( $post_data->ID, 'post_pushpage' );
			if ( isset( $pushpage[0] ) ) {
				
				$pushpage = $pushpage[0];
				
			} else {
				
				$pushpage = 1;
			}
			
			$screenfixed = 0;
			
			if ( $placement != 'bottom' ) {
				
				$screenfixed = get_post_meta( $post_data->ID, 'post_screenfixed' );
				if ( isset( $screenfixed[0] ) ) {
					
					$screenfixed = $screenfixed[0];
					
				} else {
					
					$screenfixed = 1;
				}
			}
			
			$data_path_to = null;
			$svg = null;
			
			if ( $divibar_effect == 'divibar-cornershape' ) {
				
				$data_path_to = 'data-path-to = "m 0,0 1439.999975,0 0,805.99999 -1439.999975,0 z"';
				$svg = '<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1440 806" preserveAspectRatio="none">
						<path class="divibar-path" d="m 0,0 1439.999975,0 0,805.99999 0,-805.99999 z"/>
					</svg>';
			}
			if ( $divibar_effect == 'divibar-boxes' ) {
				
				$svg = '<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="101%" viewBox="0 0 1440 806" preserveAspectRatio="none">
						<path d="m0.005959,200.364029l207.551124,0l0,204.342453l-207.551124,0l0,-204.342453z"/>
						<path d="m0.005959,400.45401l207.551124,0l0,204.342499l-207.551124,0l0,-204.342499z"/>
						<path d="m0.005959,600.544067l207.551124,0l0,204.342468l-207.551124,0l0,-204.342468z"/>
						<path d="m205.752151,-0.36l207.551163,0l0,204.342437l-207.551163,0l0,-204.342437z"/>
						<path d="m204.744629,200.364029l207.551147,0l0,204.342453l-207.551147,0l0,-204.342453z"/>
						<path d="m204.744629,400.45401l207.551147,0l0,204.342499l-207.551147,0l0,-204.342499z"/>
						<path d="m204.744629,600.544067l207.551147,0l0,204.342468l-207.551147,0l0,-204.342468z"/>
						<path d="m410.416046,-0.36l207.551117,0l0,204.342437l-207.551117,0l0,-204.342437z"/>
						<path d="m410.416046,200.364029l207.551117,0l0,204.342453l-207.551117,0l0,-204.342453z"/>
						<path d="m410.416046,400.45401l207.551117,0l0,204.342499l-207.551117,0l0,-204.342499z"/>
						<path d="m410.416046,600.544067l207.551117,0l0,204.342468l-207.551117,0l0,-204.342468z"/>
						<path d="m616.087402,-0.36l207.551086,0l0,204.342437l-207.551086,0l0,-204.342437z"/>
						<path d="m616.087402,200.364029l207.551086,0l0,204.342453l-207.551086,0l0,-204.342453z"/>
						<path d="m616.087402,400.45401l207.551086,0l0,204.342499l-207.551086,0l0,-204.342499z"/>
						<path d="m616.087402,600.544067l207.551086,0l0,204.342468l-207.551086,0l0,-204.342468z"/>
						<path d="m821.748718,-0.36l207.550964,0l0,204.342437l-207.550964,0l0,-204.342437z"/>
						<path d="m821.748718,200.364029l207.550964,0l0,204.342453l-207.550964,0l0,-204.342453z"/>
						<path d="m821.748718,400.45401l207.550964,0l0,204.342499l-207.550964,0l0,-204.342499z"/>
						<path d="m821.748718,600.544067l207.550964,0l0,204.342468l-207.550964,0l0,-204.342468z"/>
						<path d="m1027.203979,-0.36l207.550903,0l0,204.342437l-207.550903,0l0,-204.342437z"/>
						<path d="m1027.203979,200.364029l207.550903,0l0,204.342453l-207.550903,0l0,-204.342453z"/>
						<path d="m1027.203979,400.45401l207.550903,0l0,204.342499l-207.550903,0l0,-204.342499z"/>
						<path d="m1027.203979,600.544067l207.550903,0l0,204.342468l-207.550903,0l0,-204.342468z"/>
						<path d="m1232.659302,-0.36l207.551147,0l0,204.342437l-207.551147,0l0,-204.342437z"/>
						<path d="m1232.659302,200.364029l207.551147,0l0,204.342453l-207.551147,0l0,-204.342453z"/>
						<path d="m1232.659302,400.45401l207.551147,0l0,204.342499l-207.551147,0l0,-204.342499z"/>
						<path d="m1232.659302,600.544067l207.551147,0l0,204.342468l-207.551147,0l0,-204.342468z"/>
						<path d="m-0.791443,-0.360001l207.551163,0l0,204.342438l-207.551163,0l0,-204.342438z"/>
					</svg>';
			}
			
			if ( $divibar_effect == 'divibar-genie' ) {
				
				$data_path_to = 'data-steps = "m 701.56545,809.01175 35.16718,0 0,19.68384 -35.16718,0 z;m 698.9986,728.03569 41.23353,0 -3.41953,77.8735 -34.98557,0 z;m 687.08153,513.78234 53.1506,0 C 738.0505,683.9161 737.86917,503.34193 737.27015,806 l -35.90067,0 c -7.82727,-276.34892 -2.06916,-72.79261 -14.28795,-292.21766 z;m 403.87105,257.94772 566.31246,2.93091 C 923.38284,513.78233 738.73561,372.23931 737.27015,806 l -35.90067,0 C 701.32034,404.49318 455.17312,480.07689 403.87105,257.94772 z;M 51.871052,165.94772 1362.1835,168.87863 C 1171.3828,653.78233 738.73561,372.23931 737.27015,806 l -35.90067,0 C 701.32034,404.49318 31.173122,513.78234 51.871052,165.94772 z;m 52,26 1364,4 c -12.8007,666.9037 -273.2644,483.78234 -322.7299,776 l -633.90062,0 C 359.32034,432.49318 -6.6979288,733.83462 52,26 z;m 0,0 1439.999975,0 0,805.99999 -1439.999975,0 z"';
				$svg = '<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1440 806" preserveAspectRatio="none">
						<path class="divibar-path" d="m 701.56545,809.01175 35.16718,0 0,19.68384 -35.16718,0 z"/>
					</svg>';
			}
			
			$customizeclosebtn = get_post_meta( $post_data->ID, 'post_do_customizeclosebtn' );
			if( !isset( $customizeclosebtn[0] ) ) {
				
				$customizeclosebtn[0] = '0';
			}
			
			$close_cookie = get_post_meta( $post_data->ID, 'post_closebtn_cookie', true );
			if( !isset( $close_cookie ) ) {
				
				$close_cookie = 1;
			}
			
			$is_mobile = self::$isMobileDevice;
			
			if ( !$is_mobile ) {
				
				$is_mobile = 0;
			}
			
			$body = $output;
			
			require( DIVI_BARS_PLUGIN_DIR . '/templates/divibar.php');
		}
		
		
		/**
		 * Log debugging infoormation to the error log.
		 *
		 * @param string $e The Exception object
		 */
		public static function log( $e = FALSE ) {
			
			$data_log = $e;
			
			if ( is_object( $e ) ) {
				
				$data_log = sprintf( "Exception: \n %s \n", $e->getMessage() . "\r\n\r\n" . $e->getFile() . "\r\n" . 'Line:' . $e->getLine() );
			}
			
			if ( apply_filters( 'divibars_log', defined( 'WP_DEBUG' ) && WP_DEBUG && defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG ) ) {
				error_log( print_r( compact( 'data_log' ), true ) );
			}
		}
		
	} // end DiviBars_Controller