<?php

	class DiviBars_Admin_Controller {
		
		protected static $_show_errors = FALSE;
		
		private static $list_posts = array();
		
		private static function get_wp_posts() {
			
			$post_types = get_post_types();
			
			$posts = array();
			
			foreach( $post_types as $post_type) {
				
				if ( $post_type == 'attachment'
					|| $post_type == 'revision'
					|| $post_type == 'nav_menu_item'
					|| $post_type == 'custom_css'
					|| $post_type == 'et_pb_layout'
					|| $post_type == 'divi_bars'
					|| $post_type == 'divi_overlay'
					|| $post_type == 'customize_changeset' ) {
						
					continue;
				}
				
				$args = array(
					'post_type' => $post_type,
					'cache_results'  => true,
					'posts_per_page' => -1
				);
				$query = new WP_Query( $args );
				
				$get_posts = $query->get_posts();
				
				$posts = array_merge($posts, $get_posts);
			}
			
			return $posts;
		}
		
		
		public static function add_meta_boxes() {
			
			$screen = get_current_screen();
			
			self::$list_posts = self::get_wp_posts(); 
			
			if( 'add' != $screen->action ) {
				
				add_meta_box( 
					'divibars_manualtriggers', 
					esc_html__( 'Manual Triggers', 'DiviBars' ), 
					array( 'DiviBars_Admin_Controller', 'manualtriggers_callback' ), 
					'divi_bars', 
					'side', 
					'high' 
				);
			}
			
			
			add_meta_box( 
				'divibars_color_picker', 
				'Divibars Background', 
				array( 'DiviBars_Admin_Controller', 'divibars_colorbox_callback' ), 
				'divi_bars'
			);
			
			add_meta_box( 
				'divibars_moresettings_meta_box', 
				esc_html__( 'Additional Settings', 'DiviBars' ), 
				array( 'DiviBars_Admin_Controller', 'divibars_moresettings_callback' ),
				'divi_bars', 
				'side' 
			);
			
			add_meta_box( 
				'divibars_closecustoms_meta_box', 
				esc_html__( 'Close Button Customizations', 'DiviBars' ), 
				array( 'DiviBars_Admin_Controller', 'divibars_closecustoms_callback' ), 
				'divi_bars', 
				'side' 
			);
			
			add_meta_box( 
				'divibars_automatictriggers', 
				esc_html__( 'Automatic Triggers', 'DiviBars' ), 
				array( 'DiviBars_Admin_Controller', 'divibars_automatictriggers_callback' ), 
				'divi_bars', 
				'side' 
			);
		}
		
		
		public static function manualtriggers_callback( $post ) {
			?>
			<div class="custom_meta_box">
				<p>
					<label class="label-color-field"><p>CSS ID:</label>
					divibars_unique_id_<?php print $post->ID ?></p>
				</p>
				<div class="clear"></div> 
			</div> 
			<div class="custom_meta_box">
				<p>
					<label class="label-color-field"><p>Menu ID:</label>
					unique_divibars_menu_id_<?php print $post->ID ?></p>
				</p>
				<div class="clear"></div> 
			</div>
			<?php
		}
		
		
		public static function divibars_colorbox_callback( $post ) {
			
			wp_nonce_field( 'divibars_color_box', 'divibars_color_box_nonce' );
			$color = get_post_meta( $post->ID, 'post_divibars_bg_color', true );
			$fontcolor = get_post_meta( $post->ID, 'post_divibars_font_color', true );
			?>
			<div class="custom_meta_box">
				<p>
					<label class="label-color-field">Select Background Color: </label>
					<input class="cs-wp-color-picker" type="text" name="post_bg" value="<?php echo $color; ?>"/>
				</p>
				<div class="clear"></div> 
			</div> 
			<div class="custom_meta_box">
				<p>
					<label class="label-color-field">Select Font Color: </label>
					<input class="color-field" type="text" name="post_font_color" value="<?php echo $fontcolor; ?>"/>
				</p>
				<div class="clear"></div> 
			</div> 
			<script>
				(function( $ ) {
					// Add Color Picker to all inputs that have 'color-field' class
					$(function() {
						$('.color-field').wpColorPicker();
					});
				})( jQuery );
			</script>
			<?php
		}
		
		
		public static function divibars_effects_callback( $post ) {
			
			$post_id = get_the_ID();
			$divibar_effect = get_post_meta( $post_id, 'divibar_effect', true );
			$divibar_effects = array(
				'divibars-hugeinc'   => esc_html__( 'Fade & Slide', 'Divi' ),
				'divibars-corner'    => esc_html__( 'Corner', 'Divi' ),
				'divibars-slidedown' => esc_html__( 'Slide down', 'Divi' ),
				'divibars-scale' => esc_html__( 'Scale', 'Divi' ),
				'divibars-door' => esc_html__( 'Door', 'Divi' ),
				'divibars-contentpush' => esc_html__( 'Content Push', 'Divi' ),
				'divibars-contentscale' => esc_html__( 'Content Scale', 'Divi' ),
				'divibars-cornershape' => esc_html__( 'Corner Shape', 'Divi' ),
				'divibars-boxes' => esc_html__( 'Little Boxes', 'Divi' ),
				'divibars-simplegenie' => esc_html__( 'Simple Genie', 'Divi' ),
				'divibars-genie' => esc_html__( 'Genie', 'Divi' ),
			);
			?>
			<p class="et_pb_page_settings et_pb_single_title">
				<label for="divibar_effect" class="divibar-label-effect"><?php esc_html_e( 'Select DiviBars Animation', 'Divi' ); ?>: </label>
				<select id="divibar_effect" name="divibar_effect" class="chosen">
				<?php
				foreach ( $divibar_effects as $divibar_value => $divibar_name ) {
					printf( '<option value="%2$s"%3$s>%1$s</option>',
						esc_html( $divibar_name ),
						esc_attr( $divibar_value ),
						selected( $divibar_value, $divibar_effect, false )
					);
				} ?>
				</select>
			</p>
			
		<?php }
		
		
		public static function divibars_moresettings_callback( $post ) {
		
			wp_nonce_field( 'divibars_moresettings', 'divibars_moresettings_nonce' );
			
			$css_selector = get_post_meta( $post->ID, 'dib_css_selector', true );
			$at_pages = get_post_meta( $post->ID, 'css_selector_at_pages', true );
			$selectedpages = get_post_meta( $post->ID, 'css_selector_at_pages_selected' );
			if( $at_pages == '' ) {
				
				$at_pages = 'all';
			}
			
			$pushpage = get_post_meta( $post->ID, 'post_pushpage' );
			if( !isset( $pushpage[0] ) ) {
				
				$pushpage[0] = '1';
			}
			
			$screenfixed = get_post_meta( $post->ID, 'post_screenfixed' );
			if( !isset( $screenfixed[0] ) ) {
				
				$screenfixed[0] = '0';
			}
			
			$enableurltrigger = get_post_meta( $post->ID, 'dib_enableurltrigger' );
			$enableurltrigger_pages = get_post_meta( $post->ID, 'dib_enableurltrigger_pages', true );
			$enableurltrigger_selectedpages = get_post_meta( $post->ID, 'dib_enableurltrigger_selectedpages' );
			if( !isset( $enableurltrigger[0] ) ) {
				
				$enableurltrigger[0] = '0';
			}
			
			$divibar_placement = get_post_meta( $post->ID, 'dib_post_placement', true );
			
			$posts = self::$list_posts;
			
			?>
			<div class="custom_meta_box">
				<p>
					<label>CSS Selector Trigger:</label>
					<input class="css_selector" type="text" name="dib_css_selector" value="<?php echo $css_selector; ?>"/>
				</p>
				<div class="clear"></div> 
			</div>
			<div class="custom_meta_box">
				<div class="at_pages">
					<select name="css_selector_at_pages" class="at_pages chosen divibars-filter-by-pages">
						<option value="all"<?php if ( $at_pages == 'all' ) { ?> selected="selected"<?php } ?>>All pages</option>
						<option value="specific"<?php if ( $at_pages == 'specific' ) { ?> selected="selected"<?php } ?>>Only specific pages</option>
					</select>
					<div class="do-list-pages-container<?php if ( $at_pages == 'specific' ) { ?> do-show<?php } ?>">
						<select name="css_selector_at_pages_selected[]" class="chosen" data-placeholder="Choose posts or pages..." multiple tabindex="3">
					<?php
						if ( isset( $posts[0] ) ) {
							
							$selected = '';
							
							foreach( $posts as $post ) {
								
								if ( in_array( $post->ID, $selectedpages[0]) ) {
									$selected = ' selected="selected"';
								}
								
								print '<option value="' . $post->ID . '"' . $selected . '>' . $post->post_title . '</option>';
								
								$selected = '';
							}
						}
					?>
						</select>
					</div>
				</div>
				<div class="clear"></div> 
			</div>
			<?php
			
			if( !isset( $divibar_placement ) ) {
				
				$divibar_placement = 'top';
			}
			
			$divibar_ats = array(
				'top'   => esc_html__( 'Top', 'DiviBars' ),
				'bottom'    => esc_html__( 'Bottom', 'DiviBars' )
			);
			?>
			<div class="custom_meta_box">
				<p class="divibar_placement et_pb_single_title">
					<label for="dib_post_placement">Position:</label>
					<select id="dib_post_placement" name="dib_post_placement" class="post_divibar_placement chosen">
					<?php
					foreach ( $divibar_ats as $at_value => $at_name ) {
						printf( '<option value="%2$s"%3$s>%1$s</option>',
							esc_html( $at_name ),
							esc_attr( $at_value ),
							selected( $at_value, $divibar_placement, false )
						);
					} ?>
					</select>
				</p>
			</div>
			
			<div class="custom_meta_box">
				<p>
					<input name="post_pushpage" type="checkbox" id="post_pushpage" value="1" <?php checked( $pushpage[0], 1 ); ?> /> Push Page Up/Down
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box moresettings_screenfixed<?php if ( $divibar_placement == 'bottom' ) { ?> do-hide<?php } ?>">
				<p>
					<input name="post_screenfixed" type="checkbox" id="post_screenfixed" value="1" <?php checked( $screenfixed[0], 1 ); ?> /> Do not Fix to Top
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box">
				<p>
					<label for="dib_enableurltrigger"></label>
					<input name="dib_enableurltrigger" type="checkbox" class="dib_enableurltrigger" data-showhideblock=".dib_enableurltrigger_filters" value="1" <?php checked( $enableurltrigger[0], 1 ); ?> /> Enable URL Trigger
				</p>
				<div class="dib_enableurltrigger_filters<?php if ( $enableurltrigger[0] == 1 ) { ?> do-show<?php } ?>">
					<select name="dib_enableurltrigger_pages" class="dib_enableurltrigger_pages chosen divibars-filter-by-pages">
						<option value="all"<?php if ( $enableurltrigger_pages == 'all' ) { ?> selected="selected"<?php } ?>>All pages</option>
						<option value="specific"<?php if ( $enableurltrigger_pages == 'specific' ) { ?> selected="selected"<?php } ?>>Only specific pages</option>
					</select>
					<div class="do-list-pages-container<?php if ( $enableurltrigger_pages == 'specific' ) { ?> do-show<?php } ?>">
						<select name="dib_enableurltrigger_selectedpages[]" class="do-list-pages" data-placeholder="Choose posts or pages..." multiple tabindex="3">
					<?php
						if ( isset( $posts[0] ) ) {
							
							foreach( $posts as $post ) {
								
								if ( $enableurltrigger_selectedpages ) {
								
									if ( in_array( $post->ID, $enableurltrigger_selectedpages[0]) ) {
										$selected = ' selected="selected"';
									}
								
								}
								
								print '<option value="' . $post->ID . '"' . $selected . '>' . $post->post_title . '</option>';
								
								$selected = '';
							}
						}
					?>
						</select>
					</div>
				</div>
				<div class="clear"></div> 
			</div>
			<?php
		}
		
		
		public static function divibars_closecustoms_callback( $post ) {
			
			wp_nonce_field( 'divibars_closecustoms', 'divibars_closecustoms_nonce' );
			
			$close_cookie = get_post_meta( $post->ID, 'post_closebtn_cookie', true );
			$textcolor = get_post_meta( $post->ID, 'post_closebtn_text_color', true );
			$bgcolor = get_post_meta( $post->ID, 'post_closebtn_bg_color', true );
			$fontsize = get_post_meta( $post->ID, 'post_closebtn_fontsize', true );
			$borderradius = get_post_meta( $post->ID, 'post_closebtn_borderradius', true );
			$padding = get_post_meta( $post->ID, 'post_closebtn_padding', true );
			
			if( $close_cookie == '' ) {
				
				$close_cookie = 0;
			}
			
			if( $fontsize == '' ) {
				
				$fontsize = 25;
			}
			
			$hideclosebtn = get_post_meta( $post->ID, 'post_do_hideclosebtn' );
			if( !isset( $hideclosebtn[0] ) ) {
				
				$hideclosebtn[0] = '0';
			}
			
			$customizeclosebtn = get_post_meta( $post->ID, 'post_do_customizeclosebtn' );
			if( !isset( $customizeclosebtn[0] ) ) {
				
				$customizeclosebtn[0] = '0';
			}
			
			?>
			<div class="custom_meta_box">
				<p>
					<label>Close Button Cookie:</label>
					<input class="post_closebtn_cookie" type="text" name="post_closebtn_cookie" value="<?php echo $close_cookie; ?>" readonly="readonly"> days
				</p>
				<div id="slider-closebtn-cookie" class="slider-bar"></div>
			</div>
			
			<div class="custom_meta_box">
				<p>
					<input name="post_do_hideclosebtn" type="checkbox" id="post_do_hideclosebtn" value="1" <?php checked( $hideclosebtn[0], 1 ); ?> /> Hide Main Close Button
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box">
				<p>
					<input name="post_do_customizeclosebtn" type="checkbox" id="post_do_customizeclosebtn" value="1" data-showhideblock=".enable_customizations" <?php checked( $customizeclosebtn[0], 1 ); ?> /> Customize Close Button
				</p>
				<div class="enable_customizations<?php if ( $customizeclosebtn[0] == 1 ) { ?> do-show<?php } ?>">
					<div class="custom_meta_box">
						<p>
							<label class="label-color-field">Text color:</label>
							<input class="closebtn-text-color" type="text" name="post_closebtn_text_color" value="<?php echo $textcolor; ?>"/>
						</p>
						<div class="clear"></div> 
					</div> 
					<div class="custom_meta_box">
						<p>
							<label class="label-color-field">Background color:</label>
							<input class="closebtn-bg-color" type="text" name="post_closebtn_bg_color" value="<?php echo $bgcolor; ?>"/>
						</p>
						<div class="clear"></div> 
					</div>
					<div class="custom_meta_box">
						<p>
							<label>Font size:</label>
							<input class="post_closebtn_fontsize" type="text" name="post_closebtn_fontsize" value="<?php echo $fontsize; ?>" readonly="readonly" > px
						</p>
						<div id="slider-closebtn-fontsize" class="slider-bar"></div>
					</div>
					<div class="custom_meta_box">
						<p>
							<label>Border radius:</label>
							<input class="post_closebtn_borderradius" type="text" name="post_closebtn_borderradius" value="<?php echo $borderradius; ?>" readonly="readonly" > %
						</p>
						<div id="slider-closebtn-borderradius" class="slider-bar"></div>
					</div>
					<div class="custom_meta_box">
						<p>
							<label>Padding:</label>
							<input class="post_closebtn_padding" type="text" name="post_closebtn_padding" value="<?php echo $padding; ?>" readonly="readonly" > px
						</p>
						<div id="slider-closebtn-padding" class="slider-bar"></div>
					</div>
					<div class="custom_meta_box">
						<p>
							<label>Preview:</label>
						</p>
						<button type="button" class="divibars-customclose-btn"><span>&times;</span></button>
					</div>
				</div>
				<div class="clear"></div> 
			</div>
			<?php
		}
		
		
		public static function divibars_automatictriggers_callback( $post ) {
			
			$post_id = get_the_ID();
			
			$disablemobile = get_post_meta( $post_id, 'divibars_automatictrigger_disablemobile' );
			$onceperload = get_post_meta( $post_id, 'divibars_automatictrigger_onceperload' );
			$at_pages = get_post_meta( $post->ID, 'at_pages', true );
			$selectedpages = get_post_meta( $post->ID, 'at_pages_selected' );
			
			$enable_scheduling = get_post_meta( $post_id, 'divibars_enable_scheduling' );
			$date_start = get_post_meta( $post->ID, 'divibars_date_start', true );
			$date_end = get_post_meta( $post->ID, 'divibars_date_end', true );
			$date_start = DiviBars_Admin::$helper->convertDateToUserTimezone( $date_start );
			$date_end = DiviBars_Admin::$helper->convertDateToUserTimezone( $date_end );
			
			$posts = self::$list_posts;
			
			if( $at_pages == '' ) {
				
				$at_pages = 'all';
			}
			
			$divibar_at_selected = get_post_meta( $post_id, 'divibars_automatictrigger', true );
			$divibar_ats = array(
				'divibar-timed'   => esc_html__( 'Timed Delay', 'DiviBars' ),
				'divibar-scroll'    => esc_html__( 'Scroll Percentage', 'DiviBars' ),
				'divibar-exit' => esc_html__( 'Exit Intent', 'DiviBars' ),
			);
			
			if( !isset( $disablemobile[0] ) ) {
				
				$disablemobile[0] = '1';
			}
			
			if( !isset( $onceperload[0] ) ) {
				
				$onceperload[0] = '1';
			}
			
			if( !isset( $enable_scheduling[0] ) ) {
				
				$enable_scheduling[0] = '0';
			}
			?>
			<p class="divi_automatictrigger_settings et_pb_single_title">
				<label for="post_divibar_automatictrigger"></label>
				<select id="post_divibar_automatictrigger" name="post_divibar_automatictrigger" class="post_divibar_automatictrigger chosen">
					<option value="">None</option>
				<?php
				foreach ( $divibar_ats as $at_value => $at_name ) {
					printf( '<option value="%2$s"%3$s>%1$s</option>',
						esc_html( $at_name ),
						esc_attr( $at_value ),
						selected( $at_value, $divibar_at_selected, false )
					);
				} ?>
				</select>
			</p>
			
			<?php
			
				$at_timed = get_post_meta( $post->ID, 'divibars_automatictrigger_timed_value', true );
				$at_scroll_from = get_post_meta( $post->ID, 'divibars_automatictrigger_scroll_from_value', true );
				$at_scroll_to = get_post_meta( $post->ID, 'divibars_automatictrigger_scroll_to_value', true );
			?>
			<div class="divi_automatictrigger_timed<?php if ( $divibar_at_selected == 'divibar-timed' ) { ?> do-show<?php } ?>">
				<p>
					<label>Specify timed delay (in seconds):</label>
					<input class="post_at_timed" type="text" name="post_at_timed" value="<?php echo $at_timed; ?>"/>
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="divi_automatictrigger_scroll<?php if ( $divibar_at_selected == 'divibar-scroll' ) { ?> do-show<?php } ?>">
				<p>Specify in pixels or percentage:</p>
				<div class="at-scroll-settings">
					<label for="post_at_scroll_from">From:</label>
					<input class="post_at_scroll" type="text" name="post_at_scroll_from" value="<?php echo $at_scroll_from; ?>"/>
					<label for="post_at_scroll_to">to:</label>
					<input class="post_at_scroll" type="text" name="post_at_scroll_to" value="<?php echo $at_scroll_to; ?>"/>
				</div> 
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box">
				<p>
					<input name="post_at_disablemobile" type="checkbox" id="post_at_disablemobile" value="1" <?php checked( $disablemobile[0], 1 ); ?> /> Disable On Mobile
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box">
				<p>
					<input name="post_at_onceperload" type="checkbox" id="post_at_onceperload" value="1" <?php checked( $onceperload[0], 1 ); ?> />
					 Display once per page load
				</p>
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box">
				<div class="at_pages">
					<select name="post_at_pages" class="at_pages chosen divibars-filter-by-pages">
						<option value="all"<?php if ( $at_pages == 'all' ) { ?> selected="selected"<?php } ?>>All pages</option>
						<option value="specific"<?php if ( $at_pages == 'specific' ) { ?> selected="selected"<?php } ?>>Only specific pages</option>
					</select>
					<div class="do-list-pages-container<?php if ( $at_pages == 'specific' ) { ?> do-show<?php } ?>">
						<select name="post_at_pages_selected[]" class="chosen" data-placeholder="Choose posts or pages..." multiple tabindex="3">
					<?php
						if ( isset( $posts[0] ) ) {
							
							$selected = '';
							
							foreach( $posts as $post ) {
								
								if ( in_array( $post->ID, $selectedpages[0]) ) {
									$selected = ' selected="selected"';
								}
								
								print '<option value="' . $post->ID . '"' . $selected . '>' . $post->post_title . '</option>';
								
								$selected = '';
							}
						}
					?>
						</select>
					</div>
				</div>
				<div class="clear"></div> 
			</div>
			
			<div class="custom_meta_box">
				<p>
					<input name="dib_enable_scheduling" type="checkbox" id="dib_enable_scheduling" value="1" data-showhideblock=".form_schedule" <?php checked( $enable_scheduling[0], 1 ); ?> /> Enable Scheduling
				</p>
				<div class="form_schedule<?php if ( $enable_scheduling[0] == 1 ) { ?> do-show<?php } ?>">
					<p>
					<label>
						Start date <br/>
						<input type="text" name="dib_date_start" value="<?php print $date_start; ?>" />
					</label>
					</p>
					<p>
					<label>
						End date <br/>
						<input type="text" name="dib_date_end" value="<?php print $date_end; ?>" />
					</label>
					</p>
				</div>
				<div class="clear"></div> 
			</div>
			
			<?php
		}
		
		
		public static function save_post( $post_id, $post ) {
			
			global $pagenow;

			if ( 'post.php' != $pagenow ) return $post_id;

			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
				return $post_id;

			$post_type = get_post_type_object( $post->post_type );
			if ( ! current_user_can( $post_type->cap->edit_post, $post_id ) )
				return $post_id;
			
			$post_value = '';
			
			if ( isset( $_POST['post_bg'] ) ) {
				update_post_meta( $post_id, 'post_divibars_bg_color', sanitize_text_field( $_POST['post_bg'] ) );
			}
			if ( isset( $_POST['post_font_color'] ) ) {
				update_post_meta( $post_id, 'post_divibars_font_color', sanitize_text_field( $_POST['post_font_color'] ) );
			}
			
			
			/* Additional Settings */
			if ( isset( $_POST['dib_css_selector'] ) ) {
				update_post_meta( $post_id, 'dib_css_selector', sanitize_text_field( $_POST['dib_css_selector'] ) );
			}
			
			if ( isset( $_POST['css_selector_at_pages'] ) ) {
				
				$post_value = sanitize_text_field( $_POST['css_selector_at_pages'] );
				update_post_meta( $post_id, 'css_selector_at_pages', $post_value );
			}
			
			if ( $post_value == 'specific' ) {
				
				if ( isset( $_POST['css_selector_at_pages_selected'] ) ) {
					update_post_meta( $post_id, 'css_selector_at_pages_selected', $_POST['css_selector_at_pages_selected'] );
				}
			}
			else {
				
				update_post_meta( $post_id, 'css_selector_at_pages_selected', '' );
			}
			
			update_post_meta( $post_id, 'dib_post_placement', sanitize_text_field( $_POST['dib_post_placement'] ) );
			
			if ( isset( $_POST['post_pushpage'] ) ) {
				
				$post_pushpage = 1;
				
			} else {
				
				$post_pushpage = 0;
			}
			update_post_meta( $post_id, 'post_pushpage', $post_pushpage );
			
			
			if ( isset( $_POST['dib_enableurltrigger'] ) ) {
				
				$dib_enableurltrigger = 1;
				
				if ( isset( $_POST['dib_enableurltrigger_pages'] ) ) {
					$post_value = sanitize_text_field( $_POST['dib_enableurltrigger_pages'] );
					update_post_meta( $post_id, 'dib_enableurltrigger_pages', $post_value );
				}
				
				if ( $post_value == 'specific' ) {
					
					if ( isset( $_POST['dib_enableurltrigger_selectedpages'] ) ) {
						update_post_meta( $post_id, 'dib_enableurltrigger_selectedpages', $_POST['dib_enableurltrigger_selectedpages'] );
					}
				}
				else {
					
					update_post_meta( $post_id, 'dib_enableurltrigger_selectedpages', '' );
				}
				
			} else {
				
				$dib_enableurltrigger = 0;
			}
			update_post_meta( $post_id, 'dib_enableurltrigger', $dib_enableurltrigger );
			
			
			
			if ( isset( $_POST['post_screenfixed'] ) ) {
				
				$post_screenfixed = 1;
				
			} else {
				
				$post_screenfixed = 0;
			}
			update_post_meta( $post_id, 'post_screenfixed', $post_screenfixed );
			
			
			if ( isset( $_POST['post_divibar_automatictrigger'] ) ) {
				
				update_post_meta( $post_id, 'divibars_automatictrigger', sanitize_text_field( $_POST['post_divibar_automatictrigger'] ) );
			
				if ( isset( $_POST['post_at_timed'] ) ) {
					update_post_meta( $post_id, 'divibars_automatictrigger_timed_value', sanitize_text_field( $_POST['post_at_timed'] ) );
				}
				
				if ( isset( $_POST['post_at_scroll_from'] ) || isset( $_POST['post_at_scroll_to'] ) ) {
					update_post_meta( $post_id, 'divibars_automatictrigger_scroll_from_value', sanitize_text_field( $_POST['post_at_scroll_from'] ) );
					update_post_meta( $post_id, 'divibars_automatictrigger_scroll_to_value', sanitize_text_field( $_POST['post_at_scroll_to'] ) );
				}
				
				if ( isset( $_POST['post_at_disablemobile'] ) ) {
					
					$post_at_disablemobile = 1;
					
				} else {
					
					$post_at_disablemobile = 0;
				}
				
				if ( isset( $_POST['post_at_onceperload'] ) ) {
					
					$post_at_onceperload = 1;
					
				} else {
					
					$post_at_onceperload = 0;
				}
				
				update_post_meta( $post_id, 'divibars_automatictrigger_onceperload', $post_at_onceperload );
				
				if ( isset( $_POST['post_at_pages'] ) ) {
					
					$post_value = sanitize_text_field( $_POST['post_at_pages'] );
					update_post_meta( $post_id, 'at_pages', $post_value );
				}
				
				if ( $post_value == 'specific' ) {
					
					if ( isset( $_POST['post_at_pages_selected'] ) ) {
						update_post_meta( $post_id, 'at_pages_selected', $_POST['post_at_pages_selected'] );
					}
				}
				else {
					
					update_post_meta( $post_id, 'at_pages_selected', '' );
				}
				
				
			} else {
				
				$post_at_disablemobile = 0;
			}
			update_post_meta( $post_id, 'divibars_automatictrigger_disablemobile', $post_at_disablemobile );
			
			/* Close Button Customizations */
			if ( isset( $_POST['post_closebtn_cookie'] ) ) {
				update_post_meta( $post_id, 'post_closebtn_cookie', sanitize_text_field( $_POST['post_closebtn_cookie'] ) );
			}
			
			if ( isset( $_POST['post_do_hideclosebtn'] ) ) {
				
				$post_do_hideclosebtn = 1;
				
			} else {
				
				$post_do_hideclosebtn = 0;
			}
			update_post_meta( $post_id, 'post_do_hideclosebtn', $post_do_hideclosebtn );
			
			if ( isset( $_POST['post_do_customizeclosebtn'] ) ) {
				
				$post_do_customizeclosebtn = 1;
				
			} else {
				
				$post_do_customizeclosebtn = 0;
			}
			update_post_meta( $post_id, 'post_do_customizeclosebtn', $post_do_customizeclosebtn );
			
			if ( isset( $_POST['post_closebtn_text_color'] ) ) {
				update_post_meta( $post_id, 'post_closebtn_text_color', sanitize_text_field( $_POST['post_closebtn_text_color'] ) );
			}
			
			if ( isset( $_POST['post_closebtn_bg_color'] ) ) {
				update_post_meta( $post_id, 'post_closebtn_bg_color', sanitize_text_field( $_POST['post_closebtn_bg_color'] ) );
			}
			
			if ( isset( $_POST['post_closebtn_fontsize'] ) ) {
				update_post_meta( $post_id, 'post_closebtn_fontsize', sanitize_text_field( $_POST['post_closebtn_fontsize'] ) );
			}
			
			if ( isset( $_POST['post_closebtn_borderradius'] ) ) {
				update_post_meta( $post_id, 'post_closebtn_borderradius', sanitize_text_field( $_POST['post_closebtn_borderradius'] ) );
			}
			
			if ( isset( $_POST['post_closebtn_padding'] ) ) {
				update_post_meta( $post_id, 'post_closebtn_padding', sanitize_text_field( $_POST['post_closebtn_padding'] ) );
			}
			
			if ( isset( $_POST['dib_enable_scheduling'] ) ) {
				
				$post_do_customizeclosebtn = 1;
				
			} else {
				
				$post_do_customizeclosebtn = 0;
			}
			update_post_meta( $post_id, 'divibars_enable_scheduling', $post_do_customizeclosebtn );
			
			/* Save Scheduling */
			if ( isset( $_POST['dib_enable_scheduling'] ) ) {
				
				$divibars_settings = get_option( 'dib_settings' );
				
				$timezone = DIVI_SERVER_TIMEZONE;
				
				if ( isset( $divibars_settings['dib_timezone'] ) ) {
					
					$timezone = $divibars_settings['dib_timezone'];
				}
			
				if ( isset( $_POST['dib_date_start'] ) ) {
					
					$date_string = DiviBars_Admin::$helper->convertDateToUTC( $_POST['dib_date_start'], $timezone );
					
					update_post_meta( $post_id, 'divibars_date_start', sanitize_text_field( $date_string ) );
				}
				
				if ( isset( $_POST['dib_date_end'] ) ) {
					
					$date_string = DiviBars_Admin::$helper->convertDateToUTC( $_POST['dib_date_end'], $timezone );
					
					update_post_meta( $post_id, 'divibars_date_end', sanitize_text_field( $date_string ) );
				}
			}
		}
		
		
		public static function add_admin_submenu() {
			
			// Admin page
			add_submenu_page( 'edit.php?post_type=divi_bars', 'Divi Bars', 'Settings', 'edit_posts', 'divibars-settings', array( 'DiviBars_Admin_Controller', 'admin_settings' ) );
		}
		
		
		public static function admin_settings() {
			
			self::display_configuration_page();
		}
		
		
		public static function display_configuration_page() {
			
			DiviBars_Admin::$options = get_option( 'dib_settings' );
        ?>
        <div class="wrap">
            <h1>Divi Bars</h1>
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'divibars_settings' );
                do_settings_sections( 'divibars-settings' );
                submit_button();
            ?>
            </form>
        </div>
        <?php
		
		}
		
	} // end DiviBars_Admin_Controller