<?php
/*
Plugin Name: Divi Bars
Plugin URL: https://divilife.com/
Description: Create slide-in promo bars using the Divi Builder.
Version: 1.0.4
Author: Divi Life — Tim Strifler
Author URI: https://divilife.com
*/

// Make sure we don't expose any info if called directly or may someone integrates this plugin in a theme
if ( class_exists('DiviBars') || !defined('ABSPATH') || !function_exists( 'add_action' ) ) {
	
	return;
}

define( 'DIVI_BARS_VERSION', '1.0.4');
define( 'DIVI_BARS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'DIVI_BARS_PLUGIN_NAME', trim( dirname( DIVI_BARS_PLUGIN_BASENAME ), '/' ) );
define( 'DIVI_BARS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'DIVI_BARS_PLUGIN_URL', plugin_dir_url( __FILE__ ));
define( 'DIVI_SERVER_TIMEZONE', 'UTC');
define( 'DIVI_SCHEDULING_DATETIME_FORMAT', 'm\/d\/Y g:i A');

require_once( DIVI_BARS_PLUGIN_DIR . '/class.divi-bars.core.php' );

add_action( 'init', array( 'DiviBars', 'init' ) );
	
if ( is_admin() || ( defined( 'WP_CLI' ) && WP_CLI ) ) {
	
	require_once( DIVI_BARS_PLUGIN_DIR . '/class.divi-bars.admin.core.php' );
	add_action( 'init', array( 'DiviBars_Admin', 'init' ) );
}


// Keep this at very bottom
// Load the API Key library if it is not already loaded. Must be placed in the root plugin file.
if ( ! class_exists( 'divibars_lm' ) ) {

    require_once( DIVI_BARS_PLUGIN_DIR . 'divibars_lm.php' );

    // Uncomment next line if this is a theme
    // require_once( get_stylesheet_directory() . 'am-license-menu.php' );

    /**
     * @param string $file             Must be __FILE__ from the root plugin file, or theme functions file.
     * @param string $software_title   Must be exactly the same as the Software Title in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme  'plugin' or 'theme'
     * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     *
     * @return \AM_License_Submenu|null
     */
    divibars_lm::instance( __FILE__, 'Divi Bars', DIVI_BARS_VERSION, 'plugin', 'https://divilife.com/' );
}