<?php
/**
 * The Template for displaying Grid Extended Layout
 *
 * This template can be overridden by copying it to yourtheme/divi-blog-extras/layouts/grid_extended.php.
 *
 * HOWEVER, on occasion Divi-Blog-Extras will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen.
 *
 * @author      Elicus Technologies <hello@elicus.com>
 * @link        https://www.elicus.com/
 * @copyright   2018 Elicus Technologies Private Limited
 * @version     2.1.0
 */
 
if ( isset( $counter ) && $counter == 1 ) {
    
    if ( '' !== $show_categories ) {
        
        if ( '' !== $category_color ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .et_pb_post_extra .post-categories a',
                'declaration' => sprintf(
                    'color: %1$s;',
                    esc_html( $category_color )
                ),
            ) );
        }
        
        if ( '' !== $category_hover_color ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .et_pb_post_extra .post-categories a:hover',
                'declaration' => sprintf(
                    'color: %1$s;',
                    esc_html( $category_hover_color )
                ),
            ) );
        }
        
        if ( '' !== $category_background ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .et_pb_post_extra .post-categories a',
                'declaration' => sprintf(
                    'background-color: %1$s',
                    esc_html( $category_background )
                ),
            ) );
        }
        
        if ( '' !== $category_hover_background ) {
            ET_Builder_Element::set_style( $render_slug, array(
                'selector'    => '%%order_class%% .et_pb_post_extra .post-categories a:hover',
                'declaration' => sprintf(
                    'background-color: %1$s;',
                    esc_html( $category_hover_background )
                ),
            ) );
        }
    
    }
    
    if ( '' !== $show_more ) {
        ET_Builder_Element::set_style( $render_slug, array(
            'selector'    => '%%order_class%% .' . trim( $layout_class ) . ' a.more-link',
            'declaration' => sprintf(
                'border-color: %1$s !important;',
                esc_html( et_get_option('accent_color', '#2ea3f2') )
            ),
        ) );
    }
}


/**
 * Post Content
 */
$posts  .= '<div class="post-content">';

if ( 'on' === $show_categories ) {
    /**
     * Creating Categories links
     */
    $categories     = get_the_category( $postID );
    $category_list  = '';    
    if ( 'on' === $category_meta_colors ) {
        foreach ( $categories as $category ) {
            $color              = get_term_meta( $category->term_id, 'el_term_color', true );
            $hover_color        = get_term_meta( $category->term_id, 'el_term_hover_color', true );
            $bgcolor            = get_term_meta( $category->term_id, 'el_term_bgcolor', true );
            $hover_bgcolor      = get_term_meta( $category->term_id, 'el_term_hover_bgcolor', true );
            $color_style        = ( '' !== $color )             ? 'color: ' . $color . ';'                          : '';
            $bg_style           = ( '' !== $bgcolor )           ? 'background-color: ' . $bgcolor . ';'             : '';
            $data_color         = ( '' !== $color )             ? ' data-color="' . $color . '"'                    : '';
            $data_hovercolor    = ( '' !== $hover_color )       ? ' data-hover-color="' . $hover_color . '"'        : '';
            $data_bg            = ( '' !== $bgcolor )           ? ' data-bgcolor="' . $bgcolor . '"'                : '';
            $data_hoverbg       = ( '' !== $hover_bgcolor )     ? ' data-hover-bgcolor="' . $hover_bgcolor . '"'    : '';
            $custom_style       = ' style="' . $color_style . $bg_style . '"';
            $category_list     .= '<a href="' . get_category_link( $category->term_id ) . '" rel="category tag"' . $data_color . $data_hovercolor . $data_bg . $data_hoverbg . $custom_style . '>' . $category->name . '</a>';
        }
    } else {
        foreach ( $categories as $category ) {
            $category_list     .= '<a href="' . get_category_link( $category->term_id ) . '" rel="category tag">' . $category->name . '</a>';
        }
    }
    
    $posts  .= '<div class="post-categories">' . $category_list . '</div>';
}


/**
 * Post Title
 */
$posts  .= '<' . $processed_header_level . ' class="entry-title"><a href="' . esc_url( get_the_permalink( $postID ) ) . '">' . get_the_title( $postID ) . '</a></' . $processed_header_level . '>';

   
/**
 * Post Meta
 */
if ( 'on' === $show_author || 'on' === $show_date || 'on' === $show_comments ) {
    $posts .= sprintf( '<p class="post-meta">%1$s %2$s %3$s %4$s %5$s</p>',
        (
        'on' === $show_author
            ? et_get_safe_localization( sprintf( __( 'By %s', 'et_builder' ), '<span class="author vcard">' .  get_the_author_posts_link() . '</span>' ) )
            : ''
        ),
        (
        ( 'on' === $show_author && 'on' === $show_date )
            ? ' | '
            : ''
        ),
        (
        'on' === $show_date
            ? et_get_safe_localization( sprintf( __( '%s', 'et_builder' ), '<span class="published">' . esc_html( get_the_date( $meta_date, $postID ) ) . '</span>' ) )
            : ''
        ),
        (
        ( ( 'on' === $show_author || 'on' === $show_date ) && 'on' === $show_comments )
            ? ' | '
            : ''
        ),
        (
        'on' === $show_comments
            ? sprintf( esc_html( _nx( '1 Comment', '%s Comments', get_comments_number(), 'number of comments', 'et_builder' ) ), number_format_i18n( get_comments_number() ) )
            : ''
        )
    );
}


/**
 * Post Excerpt/Content
 */
$post_object    = get_post( $postID );
$post_content   = el_blog_strip_shortcodes( $post_object->post_content, true );

if ( 'on' === $show_content ) {
    global $more;
    
    // page builder doesn't support more tag, so display the_content() in case of post made with page builder
    if ( et_pb_is_pagebuilder_used( $postID ) ) {
        $more   = 1;
        $posts .= apply_filters( 'the_content', $post_content );
    } else {
        $more   = null;
        $posts .= apply_filters( 'the_content', $post_content );
    }
    
} else {
    if ( has_excerpt() ) {
        $posts .= el_blog_strip_shortcodes( get_the_excerpt( $postID ) );
    } else {
        if ( $excerpt_length != 0 ) {
            $posts .= wpautop( strip_shortcodes( el_blog_truncate_post( $excerpt_length, false, $post_object, true ) ) );
        }
    }
}

if ( 'on' !== $show_content ) {
    $posts .= $more = 'on' == $show_more ? sprintf( ' <a href="%1$s" class="more-link" >%2$s</a>' , esc_url( get_permalink( $postID ) ), esc_html__( $read_more_text, 'et_builder' ) )  : '';   
}
    
$posts  .= '</div> <!-- post-content -->';


/**
 * Post Featured Image
 */
if ( '' !== $thumb && 'on' === $show_thumbnail ) {
    /**
     * Retrieving Alt text
     */
    $attach_id  = function_exists( 'attachment_url_to_postid' ) ? attachment_url_to_postid( $thumb ) : '';
    
    if ( $attach_id != 0 && $attach_id != '' && $attach_id != '0' ) {
        $alttext = get_post_meta( $attach_id, '_wp_attachment_image_alt', true );
    } else {
        $alttext = get_the_title( $postID );
    }
    
    $alttext    = '' != $alttext ? $alttext : get_the_title( $postID );
    
    $posts  .= '<div class="post-media">';
    $posts  .= '<a href="' . esc_url( get_the_permalink( $postID ) ) . '" class="entry-featured-image-url">';
    $posts  .= print_thumbnail( $thumb, $thumbnail["use_timthumb"], $alttext, $width, $height, '', false );
    if ( 'on' === $use_overlay ) {
        $posts  .=  $overlay_output;
    }
    $posts  .= '</a>';
    $posts  .= '</div> <!-- post-media -->';
}
?>