<?php

class El_Blog_DiviBlogExtras extends DiviExtension {

	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 2.1.0
	 *
	 * @var string
	 */
	public $gettext_domain = 'et_builder';

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 2.1.0
	 *
	 * @var string
	 */
	public $name = 'Divi-Blog-Extras';

	/**
	 * The extension's version
	 *
	 * @since 2.1.0
	 *
	 * @var string
	 */
	public $version = ELICUS_BLOG_VERSION;

	/**
	 * Elicus_DiviBlogExtras constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $name = 'Divi-Blog-Extras', $args = array() ) {
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir );

		parent::__construct( $name, $args );
		$this->plugin_setup();
	}
	/**
	 * Elicus_DiviBlogExtras plugin setup function.
	 *
	 */
	public function plugin_setup() {
		require_once plugin_dir_path( __FILE__ ) . 'src/functions.php';	
		require_once plugin_dir_path( __FILE__ ) . 'src/class-update.php';
	}
}
new El_Blog_DiviBlogExtras;